<?php
$title='Mensajes';
require_once __DIR__ . '/../inc/header.php';
$pdo=db();
ensure_schema_safe();

$u=current_user();
$uid=(int)$u['id'];

if(is_client_user()){
  $cid=(int)($u['client_id'] ?? 0);
  if(!$cid){ flash_set('danger','Tu usuario no está asociado a un cliente.'); redirect('logout.php'); }
  $st=$pdo->prepare("SELECT * FROM messages WHERE client_id=? ORDER BY created_at DESC, id DESC LIMIT 500");
  $st->execute([$cid]);
  $rows=$st->fetchAll();
  $pdo->prepare("UPDATE messages SET is_read=1 WHERE client_id=? AND is_read=0")->execute([$cid]);
} else {
  $st=$pdo->prepare("SELECT um.*, u2.username AS sender_name
                     FROM user_messages um
                     JOIN users u2 ON u2.id=um.sender_id
                     WHERE um.receiver_id=?
                     ORDER BY um.created_at DESC, um.id DESC LIMIT 500");
  $st->execute([$uid]);
  $rows=$st->fetchAll();
  $pdo->prepare("UPDATE user_messages SET is_read=1 WHERE receiver_id=? AND is_read=0")->execute([$uid]);
}
?>
<div class="d-flex justify-content-between align-items-center mb-3 flex-wrap gap-2">
  <h4 class="mb-0">Mensajes</h4>
  <?php if(!is_client_user()): ?>
    <a class="btn btn-primary" href="<?= url('messages/new.php') ?>">Nuevo mensaje</a>
  <?php endif; ?>
</div>

<div class="card shadow-sm">
  <div class="card-body">
    <?php if(empty($rows)): ?>
      <div class="text-muted">No hay mensajes.</div>
    <?php else: ?>
      <div class="list-group list-group-flush">
        <?php foreach($rows as $m): ?>
          <div class="list-group-item">
            <div class="small text-muted">
              <?= h($m['created_at']) ?>
              <?php if(!is_client_user()): ?> · De: <?= h($m['sender_name'] ?? '') ?><?php endif; ?>
            </div>
            <div class="fw-semibold"><?= h($m['subject']) ?></div>
            <div><?= nl2br(h($m['body'])) ?></div>

            <?php
              // attachments
              $files=[];
              if(table_exists('message_files')){
                $typ = is_client_user() ? 'client' : 'user';
                $fid = (int)$m['id'];
                $sf=$pdo->prepare("SELECT * FROM message_files WHERE msg_type=? AND msg_id=? ORDER BY id");
                $sf->execute([$typ,$fid]);
                $files=$sf->fetchAll();
              }
            ?>
            <?php if($files): ?>
              <div class="mt-2 small">
                <div class="text-muted">Adjuntos:</div>
                <?php foreach($files as $f): ?>
                  <div><a target="_blank" rel="noopener" href="<?= url($f['stored_path']) ?>"><?= h($f['original_name']) ?></a></div>
                <?php endforeach; ?>
              </div>
            <?php endif; ?>

            <?php if(!is_client_user()): ?>
              <div class="mt-2">
                <a class="btn btn-sm btn-outline-secondary" href="<?= url('messages/reply.php?type=user&id='.(int)$m['id']) ?>">Responder</a>
              </div>
            <?php endif; ?>
          </div>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </div>
</div>

<?php require_once __DIR__ . '/../inc/footer.php'; ?>
