<?php
require_once __DIR__ . '/inc/helpers.php';

ensure_schema_safe();

if (current_user()) { redirect('dashboard.php'); }

$error = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if(!isset($_POST['csrf']) || !hash_equals($_SESSION['csrf'] ?? '', (string)$_POST['csrf'])){
    $error = 'CSRF inválido. Recarga la página e inténtalo otra vez.';
  } else {
    $username = trim((string)($_POST['username'] ?? ''));
    $password = (string)($_POST['password'] ?? '');
    if ($username === '' || $password === '') {
      $error = 'Introduce usuario y contraseña.';
    } else {
      $pdo = db();

      // Esta instalación usa password_hash (sin columna "password").
      $st = $pdo->prepare("SELECT id, username, role, client_id, is_admin,
                                  COALESCE(avatar_url,'') AS avatar_url,
                                  password_hash AS ph
                           FROM users WHERE username=? LIMIT 1");
      $st->execute([$username]);
      $u = $st->fetch();

      if (!$u || empty($u['ph']) || !password_verify($password, (string)$u['ph'])) {
        $error = 'Usuario o contraseña incorrectos.';
      } else {
        $_SESSION['user'] = [
          'id' => (int)$u['id'],
          'username' => $u['username'],
          'role' => $u['role'] ?: ((int)$u['is_admin'] ? 'admin' : 'staff'),
          'client_id' => (int)($u['client_id'] ?? 0),
          'is_admin' => (int)$u['is_admin'],
          'avatar_url' => $u['avatar_url'] ?? '',
        ];
        flash_set('success','Bienvenido.');
        redirect('dashboard.php');
      }
    }
  }
}
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Login</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body{
      min-height:100vh;
      background: radial-gradient(1200px 800px at 20% 0%, #2a6bb3, #123a66);
      display:flex; align-items:center;
    }
    .card{border-radius:18px;}
  </style>
</head>
<body>
<div class="container" style="max-width:420px;">
  <div class="card shadow-sm">
    <div class="card-body p-4">
      <h4 class="mb-1">Iniciar sesión</h4>
      <div class="text-muted mb-3">Accede al CRM</div>
      <?php if($error): ?>
        <div class="alert alert-danger"><?= h($error) ?></div>
      <?php endif; ?>
      <form method="post" class="vstack gap-3">
        <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
        <div>
          <label class="form-label">Usuario</label>
          <input class="form-control" name="username" autocomplete="username" required>
        </div>
        <div>
          <label class="form-label">Contraseña</label>
          <input class="form-control" type="password" name="password" autocomplete="current-password" required>
        </div>
        <button class="btn btn-primary w-100">Entrar</button>
      </form>
    </div>
  </div>
</div>
</body>
</html>
