<?php
require_once __DIR__ . '/tcpdf/tcpdf.php';

function pdf_init(string $title='Documento'): TCPDF {
  $pdf = new TCPDF('P','mm','A4', true, 'UTF-8', false);
  $pdf->SetCreator('CRM');
  $pdf->SetAuthor('CRM');
  $pdf->SetTitle($title);
  $pdf->SetMargins(15, 20, 15);
  $pdf->SetAutoPageBreak(TRUE, 20);
  $pdf->setFontSubsetting(true);
  $pdf->AddPage();
  $pdf->SetFont('dejavusans','',10); // UTF-8 OK (acentos, €)
  return $pdf;
}

function pdf_header_company(TCPDF $pdf, array $company){
  if(!empty($company['logo_path']) && is_file($_SERVER['DOCUMENT_ROOT'].$company['logo_path'])){
    $pdf->Image($_SERVER['DOCUMENT_ROOT'].$company['logo_path'], 15, 15, 35);
    $pdf->Ln(20);
  }
  $pdf->SetFont('dejavusans','B',12);
  $pdf->Cell(0,6,$company['name'] ?? '',0,1);
  $pdf->SetFont('dejavusans','',9);
  foreach(['address','postal_code','city','province','nif','phone','email'] as $k){
    if(!empty($company[$k])){
      $pdf->Cell(0,5,$company[$k],0,1);
    }
  }
  $pdf->Ln(4);
}

function pdf_money(float $n): string {
  return number_format($n,2,',','.') . " €";
}
