<?php
require_once __DIR__ . '/helpers.php';
require_once __DIR__ . '/pdf_render.php';

/**
 * Build PDF bytes for email attachment.
 * We reuse render_document_pdf() but capture output to string (no headers sent).
 */
function build_document_pdf_bytes(int $doc_id): string {
  ob_start();
  // Temporarily prevent headers from breaking email route
  $hs_before = headers_sent();
  render_document_pdf($doc_id);
  return (string)ob_get_clean();
}
