<?php declare(strict_types=1); ?>
<div class="card">
  <div class="row" style="align-items:center;">
    <h2 style="margin:0;">Admin · Usuarios</h2>
    <div class="right small">Gestiona roles, permisos y altas/bajas</div>
  </div>

  <div class="grid" style="margin-top:14px;">
    <div class="card">
      <h3>Crear usuario / administrador</h3>
      <form method="post" action="index.php?route=admin_user_create">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <label>Usuario</label>
        <input name="username" required>
        <label>Email</label>
        <input type="email" name="email" required>
        <label>Contraseña</label>
        <input type="password" name="password" required>
        <label>Rol</label>
        <select name="role">
          <option value="user">user</option>
          <option value="admin">admin</option>
        </select>
        <div class="row" style="margin-top:12px;">
          <button class="btn primary" type="submit">Crear</button>
        </div>
      </form>
    </div>

    <div class="card">
      <h3>Usuarios existentes</h3>
      <table class="table">
        <thead><tr><th>ID</th><th>Usuario</th><th>Rol</th><th>R</th><th>W</th><th>Acciones</th></tr></thead>
        <tbody>
          <?php foreach ($users as $u): ?>
            <tr>
              <td class="mono"><?= (int)$u['id'] ?></td>
              <td>
                <?= e($u['username']) ?>
                <div class="small"><?= e($u['email']) ?></div>
              </td>
              <td><span class="badge"><?= e($u['role']) ?></span></td>
              <td><?= (int)$u['can_read'] ? '✅' : '❌' ?></td>
              <td><?= (int)$u['can_write'] ? '✅' : '❌' ?></td>
              <td>
                <form method="post" action="index.php?route=admin_user_update" class="row">
                  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                  <input type="hidden" name="id" value="<?= (int)$u['id'] ?>">
                  <select name="role" style="width:120px;">
                    <option value="user" <?= $u['role']==='user'?'selected':'' ?>>user</option>
                    <option value="admin" <?= $u['role']==='admin'?'selected':'' ?>>admin</option>
                  </select>
                  <select name="can_read" style="width:120px;">
                    <option value="1" <?= (int)$u['can_read']===1?'selected':'' ?>>read ✅</option>
                    <option value="0" <?= (int)$u['can_read']===0?'selected':'' ?>>read ❌</option>
                  </select>
                  <select name="can_write" style="width:140px;">
                    <option value="1" <?= (int)$u['can_write']===1?'selected':'' ?>>write ✅</option>
                    <option value="0" <?= (int)$u['can_write']===0?'selected':'' ?>>write ❌</option>
                  </select>
                  <button class="btn" type="submit">Guardar</button>
                </form>

                <?php if ((int)$u['id'] !== (int)$me['id']): ?>
                  <form method="post" action="index.php?route=admin_user_delete" onsubmit="return confirm('¿Eliminar usuario?');" style="margin-top:8px;">
                    <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                    <input type="hidden" name="id" value="<?= (int)$u['id'] ?>">
                    <button class="btn danger" type="submit">Eliminar</button>
                  </form>
                <?php else: ?>
                  <div class="small">No puedes borrarte.</div>
                <?php endif; ?>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
      <p class="small">R=lectura, W=escritura. Si quitas escritura, no podrán subir ni borrar ni mover.</p>
    </div>
  </div>
</div>
