(function(){
  function ready(fn){
    if(document.readyState === 'loading'){
      document.addEventListener('DOMContentLoaded', fn);
    } else {
      fn();
    }
  }

  ready(function(){
    var bulkForm = document.getElementById('bulkForm');
    if(!bulkForm) return;

    var csrfEl = document.getElementById('csrfToken');
    var folderEl = document.getElementById('currentFolderId');
    window.CSRF_TOKEN = csrfEl ? csrfEl.value : '';
    var CURRENT_FOLDER_ID = folderEl ? parseInt(folderEl.value, 10) : 0;

    var actionSel = bulkForm.querySelector('select[name="action"]');
    var destSel   = bulkForm.querySelector('select[name="dest_folder"]');
    var btnActions = document.getElementById('btnActions');
    var inlineCount = document.getElementById('selCountInline');

    var selAllFolders = document.getElementById('selAllFolders');
    var selAllFiles   = document.getElementById('selAllFiles');

    function toggleAll(prefix, checked){
      var cbs = document.querySelectorAll('input[name="items[]"]');
      for(var i=0;i<cbs.length;i++){
        var cb = cbs[i];
        if(cb.value && cb.value.indexOf(prefix)===0) cb.checked = checked;
      }
      updateCount();
    }
    if(selAllFolders) selAllFolders.addEventListener('change', function(e){ toggleAll('d:', e.target.checked); });
    if(selAllFiles)   selAllFiles.addEventListener('change', function(e){ toggleAll('f:', e.target.checked); });

    function selectedItems(){
      var out = [];
      var cbs = document.querySelectorAll('input[name="items[]"]:checked');
      for(var i=0;i<cbs.length;i++) out.push(cbs[i].value);
      return out;
    }
    function updateCount(){
      var n = selectedItems().length;
      if(inlineCount) inlineCount.textContent = n ? (n + " seleccionado(s)") : "Nada seleccionado";
    }
    var all = document.querySelectorAll('input[name="items[]"]');
    for(var i=0;i<all.length;i++){
      all[i].addEventListener('change', updateCount);
    }
    updateCount();

    // Modal
    var bg = document.getElementById('modalBg');
    var mAction = document.getElementById('modalAction');
    var mDest   = document.getElementById('modalDest');
    var mNew    = document.getElementById('modalNewFolder');
    var btnOk   = document.getElementById('modalOk');
    var btnCancel = document.getElementById('modalCancel');

    function closestTr(el){
      while(el && el.tagName !== 'TR') el = el.parentNode;
      return el;
    }

    function isSingleZipSelected(items){
      if(items.length !== 1) return false;
      if(items[0].indexOf('f:') !== 0) return false;
      var fid = parseInt(items[0].slice(2), 10);
      var cb = document.querySelector('input[name="items[]"][value="f:'+fid+'"]');
      if(!cb) return false;
      var tr = closestTr(cb);
      if(!tr) return false;
      var tds = tr.getElementsByTagName('td');
      if(!tds || tds.length < 2) return false;
      var txt = (tds[1].textContent || '').toLowerCase();
      return txt.indexOf('.zip') !== -1;
    }

    function openModal(){
      if(!bg || !mAction) return;
      var items = selectedItems();
      if(!items.length){ alert("Selecciona al menos un archivo o carpeta."); return; }

      var unzipOpt = mAction.querySelector('option[value="zip_extract"]');
      if(unzipOpt){
        var canUnzip = isSingleZipSelected(items);
        unzipOpt.disabled = !canUnzip;
        if(!canUnzip && mAction.value === 'zip_extract') mAction.value = 'zip_create';
      }

      if(mDest) mDest.value = "";
      if(mNew)  mNew.value  = "";
      bg.style.display = "flex";
    }
    function closeModal(){
      if(bg) bg.style.display = "none";
    }

    if(btnActions) btnActions.addEventListener('click', function(){ openModal(); });
    if(btnCancel) btnCancel.addEventListener('click', function(){ closeModal(); });
    if(bg) bg.addEventListener('click', function(e){ if(e.target===bg) closeModal(); });

    function submitZipExtract(fid, dest, newFolder){
      var f = document.createElement('form');
      f.method = 'post';
      f.action = 'index.php?route=zip_extract';
      function add(n,v){ var i=document.createElement('input'); i.type='hidden'; i.name=n; i.value=v; f.appendChild(i); }
      add('csrf', window.CSRF_TOKEN);
      add('zip_file_id', fid);
      add('dest_folder', dest || String(CURRENT_FOLDER_ID || 0));
      add('new_folder_name', newFolder || '');
      document.body.appendChild(f);
      f.submit();
    }

    if(btnOk) btnOk.addEventListener('click', function(){
      var items = selectedItems();
      var action = mAction ? mAction.value : 'zip_create';
      var dest = mDest ? mDest.value : '';
      var newFolder = mNew ? (mNew.value || '').trim() : '';

      if(action === 'delete'){
        if(!confirm("¿Borrar lo seleccionado?")) return;
        actionSel.value = 'delete';
        bulkForm.submit();
        return;
      }

      if(action === 'move'){
        if(!dest){ alert("Elige un destino."); return; }
        destSel.value = dest;
        actionSel.value = 'move';
        bulkForm.submit();
        return;
      }

      if(action === 'download_zip'){
        actionSel.value = 'download_zip';
        bulkForm.submit();
        return;
      }

      if(action === 'zip_create'){
        actionSel.value = 'zip_create';
        destSel.value = dest; // empty => current
        var nf = bulkForm.querySelector('input[name="new_folder_name"]');
        if(!nf){ nf = document.createElement('input'); nf.type='hidden'; nf.name='new_folder_name'; bulkForm.appendChild(nf); }
        nf.value = newFolder;
        bulkForm.submit();
        return;
      }

      if(action === 'zip_extract'){
        if(items.length !== 1 || items[0].indexOf('f:') !== 0){ alert("Selecciona 1 ZIP."); return; }
        var fid = parseInt(items[0].slice(2), 10);
        submitZipExtract(fid, dest, newFolder);
        return;
      }
    });

    // Drag & drop upload (no async/await)
    var dz = document.getElementById('dropZone');
    if(!dz) return;
    var status = document.getElementById('uploadStatus');
    function setStatus(msg){ if(status) status.textContent = msg; }

    function uploadWithFetch(file, folderId, done){
      if(typeof fetch !== 'function'){ done("Tu navegador no soporta fetch."); return; }
      var fd = new FormData();
      fd.append("csrf", window.CSRF_TOKEN || "");
      fd.append("folder_id", String(folderId));
      fd.append("file", file);
      fetch("index.php?route=file_upload_ajax", { method:"POST", body: fd })
        .then(function(res){ return res.json(); })
        .then(function(j){ if(!j || !j.ok) done((j && j.error) ? j.error : "Error"); else done(null); })
        .catch(function(){ done("Error de subida"); });
    }

    dz.addEventListener('dragover', function(e){ e.preventDefault(); dz.style.opacity = "0.85"; });
    dz.addEventListener('dragleave', function(){ dz.style.opacity = "1"; });
    dz.addEventListener('drop', function(e){
      e.preventDefault(); dz.style.opacity = "1";
      var files = (e.dataTransfer && e.dataTransfer.files) ? Array.prototype.slice.call(e.dataTransfer.files) : [];
      if(!files.length) return;
      setStatus("Subiendo " + files.length + " archivo(s)...");
      var folderId = CURRENT_FOLDER_ID || 0;
      var i = 0;
      function next(err){
        if(err){ setStatus("Error: " + err); return; }
        i++;
        if(i >= files.length){
          setStatus("Subida completada. Recargando...");
          location.reload();
          return;
        }
        uploadWithFetch(files[i], folderId, next);
      }
      uploadWithFetch(files[0], folderId, next);
    });
  });
})();
