(function(){
  function ready(fn){
    if(document.readyState === 'loading'){ document.addEventListener('DOMContentLoaded', fn); }
    else { fn(); }
  }

  ready(function(){
    var dz = document.getElementById('dropZone');
    if(!dz) return;

    var status = document.getElementById('uploadStatus');
    function setStatus(msg){ if(status) status.textContent = msg; }

    // find csrf and folder from upload form
    var form = dz.parentNode ? dz.parentNode.querySelector('form[action*="file_upload"]') : null;
    if(!form) form = document.querySelector('form[action*="file_upload"]');
    if(!form) return;

    var csrf = (form.querySelector('input[name="csrf"]')||{}).value || '';
    var folderId = (form.querySelector('input[name="folder_id"]')||{}).value || '0';

    function upload(file, done){
      var fd = new FormData();
      fd.append('csrf', csrf);
      fd.append('folder_id', folderId);
      fd.append('file', file);
      fetch('index.php?route=file_upload_ajax', { method:'POST', body: fd })
        .then(function(r){ return r.json(); })
        .then(function(j){ if(!j || !j.ok) done((j && j.error) ? j.error : 'Error'); else done(null); })
        .catch(function(){ done('Error'); });
    }

    dz.addEventListener('dragover', function(e){ e.preventDefault(); dz.classList.add('hover'); });
    dz.addEventListener('dragleave', function(){ dz.classList.remove('hover'); });
    dz.addEventListener('drop', function(e){
      e.preventDefault(); dz.classList.remove('hover');
      var files = (e.dataTransfer && e.dataTransfer.files) ? Array.prototype.slice.call(e.dataTransfer.files) : [];
      if(!files.length) return;
      setStatus('Subiendo ' + files.length + ' archivo(s)...');
      var i = 0;
      function next(err){
        if(err){ setStatus('Error: ' + err); return; }
        i++;
        if(i >= files.length){ setStatus('Subida completada. Recargando...'); location.reload(); return; }
        upload(files[i], next);
      }
      upload(files[0], next);
    });
  });
})();
