<?php declare(strict_types=1); ?>
<div class="card">
  <h2>Compartidos conmigo</h2>
  <p class="small">Incluye archivos y carpetas compartidas.</p>
  <table class="table">
    <thead><tr><th>Archivo</th><th>Dueño</th><th>Permiso</th><th>Acciones</th></tr></thead>
    <tbody>
      <?php if (empty($shared)): ?>
        <tr><td colspan="4" class="small">No tienes archivos compartidos.</td></tr>
      <?php endif; ?>
      <?php foreach ($shared as $fi): ?>
        <tr>
          <td><?= e($fi['orig_name']) ?></td>
          <td class="small"><?= e($fi['owner_username']) ?></td>
          <td class="badge"><?= e($fi['perm']) ?></td>
          <td class="row">
            <a class="btn" href="index.php?route=file_preview&id=<?= (int)$fi['id'] ?>">Ver</a>
            <a class="btn" href="index.php?route=file_download&id=<?= (int)$fi['id'] ?>">Descargar</a>
            <?php if ($fi['perm'] === 'write'): ?>
              <form method="post" action="index.php?route=file_rename" class="row">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="id" value="<?= (int)$fi['id'] ?>">
                <input name="name" placeholder="Renombrar" style="width:160px;">
                <button class="btn" type="submit">OK</button>
              </form>
            <?php endif; ?>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<div class="card" style="margin-top:14px;">
  <h3>Carpetas compartidas</h3>
  <table class="table">
    <thead><tr><th>Carpeta</th><th>Dueño</th><th>Permiso</th><th>Acciones</th></tr></thead>
    <tbody>
      <?php if (empty($sharedFolders)): ?>
        <tr><td colspan="4" class="small">No tienes carpetas compartidas.</td></tr>
      <?php endif; ?>
      <?php foreach ($sharedFolders as $fo): ?>
        <tr>
          <td>📁 <?= e($fo['name']==='/'?'Raíz':$fo['name']) ?></td>
          <td class="small"><?= e($fo['owner_username']) ?></td>
          <td class="badge"><?= e($fo['perm']) ?></td>
          <td><a class="btn" href="index.php?route=shared_folder&sid=<?= (int)$fo['share_id'] ?>">Abrir</a></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
