<?php
require_once __DIR__ . '/helpers.php';
require_login();
$title = $title ?? 'CRM';
$flash = flash_get();
$user = current_user();
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= h($title) ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    .nav-avatar{width:32px;height:32px;border-radius:8px;object-fit:cover;border:1px solid rgba(0,0,0,.08);background:#fff;}
    .container-wide{max-width:1200px;}
    .btn-whatsapp{white-space:nowrap;}
  </style>
</head>
<body class="bg-light">
<nav class="navbar navbar-expand-lg navbar-light bg-white border-bottom sticky-top">
  <div class="container container-wide">
    <a class="navbar-brand fw-semibold" href="<?= url('dashboard.php') ?>">CRM</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#topNav" aria-controls="topNav" aria-expanded="false" aria-label="Menú">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="topNav">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item"><a class="nav-link" href="<?= url('clientes/list.php') ?>">Clientes</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= url('presupuestos/list.php') ?>">Presupuestos</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= url('facturas/list.php') ?>">Facturas</a></li>
        <?php if(is_admin()): ?>
          <li class="nav-item"><a class="nav-link" href="<?= url('settings/index.php') ?>">Ajustes</a></li>
        <?php endif; ?>
      </ul>

      <div class="d-flex align-items-center gap-2">
        <a class="text-decoration-none text-muted small" href="<?= url('users/profile.php') ?>"><?= h($user['username'] ?? '') ?></a>
        <a href="<?= url('users/profile.php') ?>" class="d-inline-flex align-items-center">
          <img class="nav-avatar" alt="avatar" src="<?= h(avatar_url($user ?? [])) ?>">
        </a>
        <a class="btn btn-sm btn-outline-secondary" href="<?= url('logout.php') ?>">Salir</a>
      </div>
    </div>
  </div>
</nav>

<div class="container container-wide py-3">
  <?php foreach($flash as $f): ?>
    <div class="alert alert-<?= h($f['type']) ?>"><?= h($f['msg']) ?></div>
  <?php endforeach; ?>
