<?php
$title='Clientes';
require_once __DIR__ . '/../inc/header.php';
ensure_schema_safe();

$pdo=db();
$q=trim((string)($_GET['q']??''));

$sql="SELECT * FROM clients";
$params=[];
if($q!==''){
  $sql.=" WHERE nombre LIKE ? OR apellidos LIKE ? OR telefono LIKE ? OR nif_cif LIKE ?";
  $like="%$q%";
  $params=[$like,$like,$like,$like];
}
$sql.=" ORDER BY id DESC LIMIT 500";
$st=$pdo->prepare($sql);
$st->execute($params);
$rows=$st->fetchAll();

?>
<div class="d-flex justify-content-between align-items-center mb-3 flex-wrap gap-2">
  <div>
    <h4 class="mb-0">Clientes</h4>
    <div class="text-muted small">Gestiona clientes. En móvil, los botones se apilan.</div>
  </div>
  <div class="d-flex gap-2 flex-wrap">
    <a class="btn btn-primary" href="<?= url('clientes/new.php') ?>">Nuevo</a>
  </div>
</div>

<form class="row g-2 mb-3" method="get">
  <div class="col-sm-8">
    <input class="form-control" name="q" value="<?= h($q) ?>" placeholder="Buscar por nombre, teléfono, NIF...">
  </div>
  <div class="col-sm-4 d-grid d-sm-flex gap-2">
    <button class="btn btn-outline-secondary">Buscar</button>
    <a class="btn btn-outline-secondary" href="<?= url('clientes/list.php') ?>">Limpiar</a>
  </div>
</form>

<div class="table-responsive">
  <table class="table table-sm align-middle">
    <thead>
      <tr>
        <th>#</th>
        <th>Nombre</th>
        <th>Teléfono</th>
        <th>NIF/CIF</th>
        <th class="text-end">Acciones</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach($rows as $c): ?>
        <?php
          $name = trim(($c['nombre']??'').' '.($c['apellidos']??''));
          $tel = trim((string)($c['telefono'] ?? ''));
          $telDigits = $tel ? preg_replace('/[^0-9+]/','', $tel) : '';
        ?>
        <tr>
          <td><?= (int)$c['id'] ?></td>
          <td class="fw-semibold"><?= h($name) ?></td>
          <td>
            <?php if($tel): ?>
              <a href="tel:<?= h($telDigits) ?>" class="text-decoration-none"><?= h($tel) ?></a>
            <?php else: ?><span class="text-muted">—</span><?php endif; ?>
          </td>
          <td><?= h($c['nif_cif'] ?? '') ?></td>
          <td class="text-end">
            <div class="d-none d-sm-inline-flex gap-1">
              <a class="btn btn-sm btn-outline-secondary text-nowrap" href="<?= url('clientes/view.php?id='.(int)$c['id']) ?>">Ver</a>
              <a class="btn btn-sm btn-outline-secondary text-nowrap" href="<?= url('clientes/edit.php?id='.(int)$c['id']) ?>">Editar</a>
              <form method="post" action="<?= url('clientes/delete.php?id='.(int)$c['id']) ?>" onsubmit="return confirm('¿Eliminar cliente?');" style="display:inline">
                <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
                <button class="btn btn-sm btn-outline-danger text-nowrap">Eliminar</button>
              </form>
            </div>

            <!-- Mobile: stacked full-width buttons -->
            <div class="d-grid gap-1 d-sm-none">
              <a class="btn btn-sm btn-outline-secondary" href="<?= url('clientes/view.php?id='.(int)$c['id']) ?>">Ver</a>
              <a class="btn btn-sm btn-outline-secondary" href="<?= url('clientes/edit.php?id='.(int)$c['id']) ?>">Editar</a>
              <form method="post" action="<?= url('clientes/delete.php?id='.(int)$c['id']) ?>" onsubmit="return confirm('¿Eliminar cliente?');">
                <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
                <button class="btn btn-sm btn-outline-danger">Eliminar</button>
              </form>
            </div>
          </td>
        </tr>
      <?php endforeach; ?>
      <?php if(count($rows)===0): ?>
        <tr><td colspan="5" class="text-muted">No hay clientes.</td></tr>
      <?php endif; ?>
    </tbody>
  </table>
</div>

<?php require_once __DIR__ . '/../inc/footer.php'; ?>
