<?php
require_once __DIR__ . '/../inc/header.php';
require_once __DIR__ . '/../inc/docs.php';
ensure_part2_tables();

$pdo=db();
$id=(int)($_GET['id']??0);

$st=$pdo->prepare("SELECT * FROM documents WHERE id=? AND doc_type='invoice'");
$st->execute([$id]);
$inv=$st->fetch();
if(!$inv){ http_response_code(404); exit('Factura no encontrada'); }

if($_SERVER['REQUEST_METHOD']==='POST'){
  csrf_check();
  $confirm = (string)($_POST['confirm'] ?? '');
  if($confirm !== 'BORRAR'){
    flash_set('danger','Escribe BORRAR para confirmar.');
    redirect('facturas/delete.php?id='.$id);
  }
  // Aviso legal: lo correcto es rectificativa. Aun así, borramos.
  $pdo->prepare("DELETE FROM documents WHERE id=?")->execute([$id]);
  flash_set('success','Factura eliminada. Recuerda: legalmente lo correcto suele ser emitir una rectificativa.');
  redirect('facturas/list.php');
}

$title='Borrar factura';
?>
<div class="container py-3">
  <h4>Borrar factura <?= h($inv['doc_code']) ?></h4>
  <div class="alert alert-warning">
    <strong>Ojo:</strong> En España, lo correcto normalmente es hacer una <strong>factura rectificativa</strong>, no borrar.
    Solo borra si estás 100% seguro y esto no te va a dar problemas contables/fiscales.
  </div>
  <form method="post">
    <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
    <p>Para confirmar, escribe <strong>BORRAR</strong>:</p>
    <input class="form-control" name="confirm" placeholder="BORRAR" style="max-width:240px">
    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-danger">Borrar definitivamente</button>
      <a class="btn btn-outline-secondary" href="<?= url('facturas/edit.php?id='.$id) ?>">Cancelar</a>
      <a class="btn btn-outline-primary" href="<?= url('facturas/rectificativa_new.php?id='.$id) ?>">Crear rectificativa</a>
    </div>
  </form>
</div>
<?php require_once __DIR__ . '/../inc/footer.php'; ?>
