<?php
require_once __DIR__ . '/../inc/helpers.php';
require_once __DIR__ . '/../inc/pdf_helper.php';
require_login();
if(is_client_user()){ http_response_code(403); exit('No'); }

$id=(int)($_GET['id']??0);
$pdo=db();

$doc=$pdo->prepare("SELECT d.*, c.email, c.nombre, c.apellidos
                    FROM documents d JOIN clients c ON c.id=d.client_id
                    WHERE d.id=? AND d.doc_type='budget'");
$doc->execute([$id]);
$d=$doc->fetch();
if(!$d){ exit('Presupuesto no encontrado'); }
$to=trim((string)$d['email']);
if($to===''){
  flash_set('danger','Este cliente no tiene email.');
  redirect('clientes/view.php?id='.(int)$d['client_id']);
}

$company=$pdo->query("SELECT * FROM company_settings LIMIT 1")->fetch() ?: [];

$pdf=pdf_init('Presupuesto '.$d['doc_code']);
pdf_header_company($pdf, $company);

$pdf->SetFont('dejavusans','B',10);
$pdf->Cell(0,6,'Cliente',0,1);
$pdf->SetFont('dejavusans','',9);
$pdf->Cell(0,5,trim($d['nombre'].' '.$d['apellidos']),0,1);
$pdf->Ln(3);

$pdf->SetFont('dejavusans','B',9);
$pdf->Cell(110,6,'Concepto',1);
$pdf->Cell(20,6,'Cant.',1,0,'R');
$pdf->Cell(25,6,'Precio',1,0,'R');
$pdf->Cell(25,6,'Importe',1,1,'R');
$pdf->SetFont('dejavusans','',9);

$lines=$pdo->prepare("SELECT * FROM document_lines WHERE document_id=? ORDER BY line_no");
$lines->execute([$id]);
foreach($lines as $l){
  $qty = (float)($l['quantity'] ?? $l['qty'] ?? 1);
  $unit = (float)($l['unit_price'] ?? 0);
  $tot = (float)($l['total'] ?? ($qty*$unit));
  $pdf->Cell(110,6,$l['description'],1);
  $pdf->Cell(20,6,rtrim(rtrim(number_format($qty,2,'.',''), '0'), '.'),1,0,'R');
  $pdf->Cell(25,6,pdf_money($unit),1,0,'R');
  $pdf->Cell(25,6,pdf_money($tot),1,1,'R');
}

$pdf->Ln(3);
$pdf->Cell(155,6,'Total',0,0,'R');
$pdf->SetFont('dejavusans','B',10);
$pdf->Cell(25,6,pdf_money((float)$d['total']),1,1,'R');

$pdfBytes = $pdf->Output('', 'S');

$subject = "Presupuesto ".$d['doc_code'];
$body = "Hola ".trim($d['nombre'].' '.$d['apellidos']).",\n\nTe enviamos tu presupuesto en PDF.\n\nUn saludo.";
$filename = "presupuesto_".$d['doc_code'].".pdf";

$ok = send_mail_with_pdf($to, $subject, $body, $pdfBytes, $filename);

if($ok){
  flash_set('success','Presupuesto enviado a '.$to);
} else {
  flash_set('danger','No se pudo enviar el email. Tu hosting puede tener mail() deshabilitado. Si quieres, lo pasamos a SMTP.');
}
redirect('clientes/view.php?id='.(int)$d['client_id']);
