<?php
$title='Mensajes';
require_once __DIR__ . '/../inc/header.php';
if(is_client_user()){ redirect('messages/inbox.php'); }

$pdo=db();
$rows = $pdo->query("
  SELECT m.*, c.nombre, c.apellidos
  FROM messages m JOIN clients c ON c.id=m.client_id
  ORDER BY m.created_at DESC
  LIMIT 200
")->fetchAll();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4 class="mb-0">Mensajes a clientes</h4>
</div>

<div class="card shadow-sm"><div class="card-body">
  <div class="table-responsive">
    <table class="table table-sm align-middle">
      <thead><tr><th>Fecha</th><th>Cliente</th><th>Asunto</th><th>Leído</th></tr></thead>
      <tbody>
        <?php foreach($rows as $m): ?>
          <tr>
            <td><?= h($m['created_at']) ?></td>
            <td><?= h(trim($m['nombre'].' '.$m['apellidos'])) ?></td>
            <td class="fw-semibold"><?= h($m['subject']) ?></td>
            <td><?= (int)$m['is_read'] ? 'Sí' : 'No' ?></td>
          </tr>
        <?php endforeach; ?>
        <?php if(!$rows): ?><tr><td colspan="4" class="text-muted">Sin mensajes.</td></tr><?php endif; ?>
      </tbody>
    </table>
  </div>
</div></div>
<?php require_once __DIR__ . '/../inc/footer.php'; ?>
