<?php
$title='Inicio/Tablón';
require_once __DIR__ . '/inc/header.php';
$pdo=db();

if(is_client_user()){
  redirect('client/panel.php');
}

$stats = [
  'clientes' => (int)$pdo->query("SELECT COUNT(*) FROM clients")->fetchColumn(),
  'facturas' => (int)$pdo->query("SELECT COUNT(*) FROM documents WHERE doc_type='invoice'")->fetchColumn(),
  'presupuestos' => (int)$pdo->query("SELECT COUNT(*) FROM documents WHERE doc_type='budget'")->fetchColumn(),
];
$recentMsgs = $pdo->query("
  SELECT m.*, c.nombre, c.apellidos
  FROM messages m JOIN clients c ON c.id=m.client_id
  ORDER BY m.created_at DESC
  LIMIT 5
")->fetchAll();
?>
<div class="row g-3">
  <div class="col-lg-8">
    <div class="card shadow-sm"><div class="card-body">
      <h5 class="mb-3">Tablón</h5>
      <div class="row g-3">
        <div class="col-md-4"><div class="p-3 rounded-3 border"><div class="text-muted">Clientes</div><div class="fs-4 fw-semibold"><?= $stats['clientes'] ?></div></div></div>
        <div class="col-md-4"><div class="p-3 rounded-3 border"><div class="text-muted">Presupuestos</div><div class="fs-4 fw-semibold"><?= $stats['presupuestos'] ?></div></div></div>
        <div class="col-md-4"><div class="p-3 rounded-3 border"><div class="text-muted">Facturas</div><div class="fs-4 fw-semibold"><?= $stats['facturas'] ?></div></div></div>
      </div>
      <div class="text-muted mt-3">Resumen rápido. Si quieres, lo llevamos a gráficos y KPIs.</div>
    </div></div>
  </div>

  <div class="col-lg-4">
    <div class="card shadow-sm"><div class="card-body">
      <div class="d-flex justify-content-between align-items-center mb-2">
        <h6 class="mb-0">Últimos mensajes a clientes</h6>
        <a class="btn btn-sm btn-outline-primary" href="<?= url('messages/list.php') ?>">Ver todo</a>
      </div>
      <?php if(!$recentMsgs): ?>
        <div class="text-muted">Sin mensajes.</div>
      <?php else: ?>
        <div class="list-group list-group-flush">
          <?php foreach($recentMsgs as $m): ?>
            <a class="list-group-item list-group-item-action" href="<?= url('messages/list.php') ?>">
              <div class="small text-muted"><?= h($m['created_at']) ?> · <?= h(trim($m['nombre'].' '.$m['apellidos'])) ?></div>
              <div class="fw-semibold"><?= h($m['subject']) ?></div>
            </a>
          <?php endforeach; ?>
        </div>
      <?php endif; ?>
    </div></div>
  </div>
</div>

<?php require_once __DIR__ . '/inc/footer.php'; ?>
