<?php
require_once __DIR__ . '/db.php';
function start_session(): void {
  if(session_status()===PHP_SESSION_NONE){ session_name(SESSION_NAME); session_start(); }
}
function url(string $path): string {
  // Absoluta desde raíz. Evita /clientes/users/... y duplicados.
  if (preg_match('#^https?://#i', $path)) return $path;

  $base = defined('BASE_URL') ? trim((string)BASE_URL) : '';
  // Si BASE_URL es una URL completa, úsala como prefijo
  if ($base !== '' && preg_match('#^https?://#i', $base)) {
    return rtrim($base,'/') . '/' . ltrim($path,'/');
  }

  // Si BASE_URL es un subdirectorio (ej: /app), lo aplicamos
  $base = trim($base);
  if ($base !== '') {
    $base = '/' . trim($base, '/');
    return $base . '/' . ltrim($path,'/');
  }

  return '/' . ltrim($path,'/');
}
function require_login(): void {
  start_session(); if(empty($_SESSION['user_id'])){ header('Location: '.url('login.php')); exit; }
}
function current_user(): ?array {
  start_session(); if(empty($_SESSION['user_id'])) return null;
  $st=db()->prepare('SELECT id,username,is_admin,avatar_type,avatar_value FROM users WHERE id=?');
  $st->execute([$_SESSION['user_id']]); $u=$st->fetch(); return $u?:null;
}
function is_admin(): bool { $u=current_user(); return $u && (int)$u['is_admin']===1; }
function flash_set(string $type,string $msg): void { start_session(); $_SESSION['flash'][]=['type'=>$type,'msg'=>$msg]; }
function flash_get(): array { start_session(); $f=$_SESSION['flash']??[]; unset($_SESSION['flash']); return $f; }
function csrf_token(): string { start_session(); if(empty($_SESSION['csrf'])) $_SESSION['csrf']=bin2hex(random_bytes(16)); return $_SESSION['csrf']; }
function csrf_check(): void {
  start_session(); $t=$_POST['csrf']??''; 
  if(!$t || empty($_SESSION['csrf']) || !hash_equals($_SESSION['csrf'],$t)){ http_response_code(400); echo 'CSRF inválido.'; exit; }
}
function password_hash_str(string $pwd): string { return password_hash($pwd, PASSWORD_DEFAULT); }
function avatar_url(?array $u): string {
  if(!$u) return '';
  $type=$u['avatar_type']??'dicebear'; $val=$u['avatar_value']??'';
  if($type==='upload' && $val) return url('uploads/avatars/'.rawurlencode($val));
  $seed=$val ?: ($u['username']??'user');
  return DICEBEAR_BASE . rawurlencode($seed);
}
