<?php
$title='Nueva rectificativa';
require_once __DIR__ . '/../inc/header.php';
require_once __DIR__ . '/../inc/docs.php';
ensure_part2_tables();

$pdo=db();
$orig_id=(int)($_GET['id']??0);

// solo para facturas "cerradas" (paid o accepted/sent). Si no, igual se permite.
$st=$pdo->prepare("SELECT d.*, c.nombre, c.apellidos FROM documents d JOIN clients c ON c.id=d.client_id WHERE d.id=? AND d.doc_type='invoice'");
$st->execute([$orig_id]);
$orig=$st->fetch();
if(!$orig){ http_response_code(404); exit('Factura original no encontrada'); }

$lines=$pdo->prepare("SELECT * FROM document_lines WHERE document_id=? ORDER BY line_no");
$lines->execute([$orig_id]);
$orig_lines=$lines->fetchAll();

if($_SERVER['REQUEST_METHOD']==='POST'){
  csrf_check();
  // Crear rectificativa como una nueva factura con importes negativos por defecto
  $code = next_doc_code('invoice');
  $issue = date('Y-m-d');

  $pdo->beginTransaction();
  try{
    $pdo->prepare("INSERT INTO documents(doc_type,series_prefix,series_number,doc_code,client_id,issue_date,status,notes,currency,subtotal,tax_total,total,rectifies_invoice_id,is_rectificativa)
                   VALUES('invoice',?,?,?,?,?,?,?,?,0,0,0,?,1)")
        ->execute([$code['prefix'],$code['number'],$code['code'],(int)$orig['client_id'],$issue,'draft',
                   "Factura rectificativa de: ".$orig['doc_code'], 'EUR', $orig_id]);
    $new_id = (int)$pdo->lastInsertId();

    $ln_no=1;
    $payload=[];
    foreach($orig_lines as $ln){
      // copiamos pero en negativo
      $payload[]=[
        'description'=>$ln['description'],
        'qty'=>-(float)$ln['qty'],
        'unit_price'=>(float)$ln['unit_price'],
        'vat_rate'=>(int)$ln['vat_rate']
      ];
    }
    $calc = calc_totals($payload);

    // actualizar totales
    $pdo->prepare("UPDATE documents SET subtotal=?, tax_total=?, total=? WHERE id=?")
        ->execute([$calc['subtotal'],$calc['tax_total'],$calc['total'],$new_id]);

    // insertar líneas
    $ins=$pdo->prepare("INSERT INTO document_lines(document_id,line_no,description,qty,unit_price,vat_rate,line_subtotal,line_tax,line_total)
                        VALUES(?,?,?,?,?,?,?,?,?)");
    foreach($calc['lines'] as $ln){
      $ins->execute([$new_id,$ln_no++,$ln['description'],$ln['qty'],$ln['unit_price'],$ln['vat_rate'],$ln['line_subtotal'],$ln['line_tax'],$ln['line_total']]);
    }

    $pdo->commit();
    flash_set('success','Rectificativa creada (borrador). Revisa y emite.');
    redirect('facturas/edit.php?id='.$new_id);
  }catch(Throwable $e){
    $pdo->rollBack();
    throw $e;
  }
}

?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <div>
    <h4 class="mb-0">Crear factura rectificativa</h4>
    <div class="text-muted">Factura original: <strong><?= h($orig['doc_code']) ?></strong></div>
  </div>
  <a class="btn btn-outline-secondary" href="<?= url('facturas/edit.php?id='.$orig_id) ?>">Volver</a>
</div>

<div class="alert alert-info">
  Se creará una nueva factura (borrador) con las mismas líneas pero en negativo, enlazada a la factura original.
  Después puedes añadir líneas si necesitas ajustar.
</div>

<form method="post">
  <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
  <button class="btn btn-primary">Crear rectificativa</button>
</form>

<?php require_once __DIR__ . '/../inc/footer.php'; ?>
