<?php
require_once __DIR__ . '/helpers.php';
require_login();
$me=current_user(); $flash=flash_get();
?>
<!doctype html><html lang="es"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title><?= h($title ?? 'CRM') ?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css"
 integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY=" crossorigin=""/>
<style>
.sidebar{width:260px}.avatar{width:42px;height:42px;object-fit:cover;border-radius:10px;border:1px solid #e5e7eb;background:#fff}
.avatar-lg{width:96px;height:96px;object-fit:cover;border-radius:16px;border:1px solid #e5e7eb;background:#fff}
#map{width:100%;height:260px;border-radius:14px;border:1px solid #e5e7eb}
</style></head><body class="bg-light"><div class="d-flex">
<aside class="sidebar border-end bg-white min-vh-100 p-3">
  <div class="d-flex align-items-center gap-2 mb-3">
    <img class="avatar" src="<?= h(avatar_url($me)) ?>" alt="avatar">
    <div><div class="fw-semibold"><?= h($me['username']) ?></div>
      <div class="small text-muted"><?= is_admin()?'Admin':'Usuario' ?></div></div>
  </div>
  <div class="list-group mb-3">
    <a class="list-group-item list-group-item-action" href="<?= url('dashboard.php') ?>">🏠 Dashboard</a>
    <a class="list-group-item list-group-item-action" href="<?= url('clientes/list.php') ?>">👤 Clientes</a>
    <a class="list-group-item list-group-item-action" href="<?= url('presupuestos/list.php') ?>">🧾 Presupuestos</a>
    <a class="list-group-item list-group-item-action" href="<?= url('facturas/list.php') ?>">📄 Facturas</a>
    <a class="list-group-item list-group-item-action" href="<?= url('users/profile.php') ?>">⚙️ Mi perfil</a>
    <?php if(is_admin()): ?>
      <a class="list-group-item list-group-item-action" href="<?= url('settings/index.php') ?>">🛠️ Ajustes</a>
    <?php endif; ?>
  </div>
  <form method="post" action="<?= url('logout.php') ?>">
    <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
    <button class="btn btn-outline-danger w-100">Salir</button>
  </form>
</aside>
<main class="flex-grow-1 p-4">
<?php foreach($flash as $f): ?>
  <div class="alert alert-<?= h($f['type']) ?>"><?= h($f['msg']) ?></div>
<?php endforeach; ?>
